const url = require('url');
const createElement = require('react').createElement;
const renderToString = require('react-dom/server').renderToString;
const Header = require('dheader-old').Header;
const config = require('../../configs/current');

const setDHeader = (req, res, next) => {
    if (process.env.INTRANET === 'intranet') {
        return next();
    }

    const {accounts = {}, retpath, currentPage, language} = res.locals;
    const query = Object.assign({}, req.query);

    delete query.uid;
    const currentURL =
        retpath ||
        currentPage ||
        url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: req.path,
            query
        });
    const {blackbox: {connection_id: ci} = {}} = req;

    res.locals.dheader = renderToString(
        createElement(
            Header,
            {
                language,
                yandexUID: res._yandexuid && res._yandexuid.replace(/[^0-9]/g, ''),
                accounts: accounts.accounts || [],
                currentAccount: accounts.defaultAccount || {},
                currentURL,
                dev: config.dev,
                tld: req._controller.getTld(),
                activeLinkID: 0,
                onlyKUBR: true,
                avatarHost: (config.paths.avatar || {}).host || '',
                passportHost: url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname
                }),
                showSubscriptions: true,
                ci
            },
            null
        )
    );

    return next();
};

module.exports = setDHeader;
