const DocumentsApi = require('../../lib/api/documents');
const tvm = require('../../lib/tvm');

module.exports = (req, res, next) => {
    if (req._documentsAPI) {
        return next();
    }

    return req._controller
        .getAuth()
        .sessionID()
        .then((session) => {
            const uid = session && session.uid && session.uid.value;
            const serviceTicket = req.serviceTickets && req.serviceTickets[tvm.SERVICE_ALIASES.DOCUMENTS];
            const userTicket = req.userTicket;

            req._documentsAPI = new DocumentsApi(req.logID, uid, serviceTicket, userTicket);

            return next();
        });
};
