const apiSetup = require('./apiSetup');
const getYaExperimentsFlags = require('./getYaExperimentsFlags');

function expFilter({include, exclude}) {
    return [
        apiSetup,
        getYaExperimentsFlags,
        function(req, res, next) {
            const {experiments = {}} = res.locals;
            const {flags = []} = experiments;

            if ((!include || flags.includes(include)) && (!exclude || !flags.includes(exclude))) {
                return next();
            }

            return next('route');
        }
    ];
}

module.exports = {
    expFilter
};
