const BnplApi = require('../../lib/api/bnpl');

module.exports = (req, res, next) => {
    const {experiments: {flags = []} = {}} = res.locals;

    if (!flags.includes('id-bnpl-alert-exp')) {
        return next();
    }

    return new BnplApi(req.logID, req._controller.getAuth().getUid(), req.serviceTickets['bnpl'], req.userTicket)
        .getUserStat()
        .then(({account_stat, account_url}) => {
            if (!account_url) {
                return next();
            }

            res.locals.bnpl = {
                nextPaymentDate: account_stat.next_payment_date,
                nextAmount: Number(account_stat.next_payment_amount),
                amountLeft: Number(account_stat.amount_left),
                url: account_url
            };

            return next();
        })
        .catch(() => next());
};
