module.exports = function getCaptcha() {
    return [
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.captcha || (storeDraft.captcha = {});

            Object.assign(resultStore, {
                loading: false,
                loadingAudio: false,
                playing: false,
                type: 'text',
                key: null,
                imageUrl: null,
                introSound: null,
                captchaSound: null
            });

            return next();
        }
    ];
};
