const configs = {};

const importConfig = (fullPath) => {
    try {
        return require(fullPath);
    } catch {
        return {};
    }
};

module.exports = (name, devFolder) => {
    if (!configs[name]) {
        configs[name] = {};

        if (process.env.NODE_ENV !== 'development') {
            configs[name] = importConfig(`../../lib/${name}`);
        } else if (process.env.RUNNER !== 'tests') {
            configs[name] = importConfig(`../../../auth-customs/${devFolder ? `${devFolder}/${name}` : name}`);
        }
    }

    return configs[name];
};
