const putils = require('putils');
const getCustomConfig = require('./getCustomConfig');
const getOriginByOtherParams = require('./getOriginByOtherParams');
const customsConfig = getCustomConfig('customs.config.json');
const additionalCustomsConfig = getCustomConfig('additional-customs.config.json');
const {originMatcher, originMatcherCmnt} = getCustomConfig('customs.js');

module.exports = function getCustomConfigByRequest(req) {
    const {query = {}, body = {}} = req;
    const origin = getOriginByOtherParams(req) || query.origin || body.origin;

    if (!origin || typeof origin !== 'string') {
        return;
    }
    const originMatch = originMatcher.exec(origin);
    const originMatchCmnt = originMatcherCmnt.exec(origin);
    const matchedOrigin = originMatch && originMatch[1];
    const matchedOriginCmnt = originMatchCmnt && originMatchCmnt[1];

    let resultConfig;

    if (matchedOrigin && !customsConfig[origin]) {
        resultConfig = customsConfig[matchedOriginCmnt ? `cmnt_${matchedOriginCmnt}` : matchedOrigin];
    } else {
        resultConfig = customsConfig[origin];
    }

    if (!resultConfig) {
        resultConfig = {};
    }

    if (additionalCustomsConfig && Array.isArray(additionalCustomsConfig)) {
        resultConfig = additionalCustomsConfig.reduce((acc, item) => {
            if (
                item &&
                item.config &&
                typeof item.config === 'object' &&
                Array.isArray(item.origins) &&
                item.origins.includes(origin)
            ) {
                return putils.merge(acc, putils.cloneDeep(item.config));
            }
            return acc;
        }, putils.cloneDeep(resultConfig));
    }

    if (Object.keys(resultConfig).length) {
        return resultConfig;
    }
};
