const PLog = require('plog');

module.exports = function getGenderSuggest(req, res, next) {
    const data = req.body;
    const isDataForGenderSuggestAvailable = (data.firstname && data.lastname) || data.surname;

    if (isDataForGenderSuggestAvailable) {
        req._controller
            .suggestGender(data.firstname, data.lastname || data.surname)
            .then(function(gender) {
                if (gender) {
                    res.locals.gender = gender;
                }
                return next();
            })
            .catch(function(error) {
                PLog.warn()
                    .logId(req.logID)
                    .type('registration.v2')
                    .write('getGenderSuggest', error);
                return next();
            });
    } else {
        return next();
    }
};
