const url = require('url');
const uuid = require('uuid');
const config = require('../../configs/current');
const paths = config.paths;
const forcedMDADomains = require('../../configs/common').forcedMDADomains;
const retpathRe = /\.?([^.]*\.[^.]*$)/;

module.exports = function(retpath, query) {
    const parsedRetpath = url.parse(retpath, true);
    const matchedRetpath = parsedRetpath && parsedRetpath.hostname && retpathRe.exec(parsedRetpath.hostname);

    let needMDA = false;

    let redirectUrl;

    if (Array.isArray(forcedMDADomains) && forcedMDADomains.includes(matchedRetpath && matchedRetpath[1])) {
        needMDA = true;
    }

    if (needMDA) {
        redirectUrl = url.format({
            protocol: 'https',
            hostname: paths.mda,
            pathname: 'push',
            query: Object.assign({}, query, {
                uuid: uuid.v4(),
                retpath
            })
        });
    }

    return {
        needMDA,
        redirectUrl
    };
};
