const config = require('../../configs/current');
const Metrics = require('../metrics').Metrics;
const metrics = new Metrics(config.metrics);

module.exports = function getMetrics({header}) {
    return [
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.metrics || (storeDraft.metrics = {});
            const experiments = res.locals.experiments ? res.locals.experiments.encodedBoxes : '';

            Object.assign(resultStore, {
                header,
                experiments,
                counterId: metrics.getCounterID(req._controller.getUrl().pathname)
            });

            return next();
        }
    ];
};
