const {urlParse} = require('./urlFormat');
const getCustomConfig = require('./getCustomConfig');
const {domainToOriginMap = {}, clientIdToOriginMap = {}} = getCustomConfig('customs.js');

module.exports = function getOriginByOtherParams(req) {
    const domain = req._controller.getUrl().hostname;
    const {query: {retpath} = {}} = req;
    const retpathQueryParams = urlParse(retpath).query || {};
    const {client_id: clientId = ''} = retpathQueryParams;

    return domainToOriginMap[domain] || clientIdToOriginMap[clientId] || null;
};
