const url = require('url');

const createPassportLink = (req, pathname) =>
    url.format({
        protocol: 'https',
        hostname: req.hostname,
        pathname
    });

module.exports = (req) => ({
    registration: createPassportLink(req, 'registration'),
    registrationChild: createPassportLink(req, 'registration/child'),
    profile: createPassportLink(req, 'profile'),
    phones: createPassportLink(req, 'profile/phones'),
    personalInfo: createPassportLink(req, 'profile/personal-info'),
    publicId: createPassportLink(req, 'profile/publicid'),
    displayName: createPassportLink(req, 'profile/display-name'),
    profilePublic: createPassportLink(req, 'profile/public'),
    orderHistory: createPassportLink(req, 'profile/order-history'),
    journal: createPassportLink(req, 'profile/journal'),
    auth: createPassportLink(req, 'auth'),
    authRestore: createPassportLink(req, 'auth/restore')
});
