const TrustApiApi = require('../../lib/api/trustApi');
const tvm = require('../../lib/tvm');
const config = require('../../configs/current');
const isFamilyEnable = require('./isFamilyEnable');
const plusLink = config.paths && config.paths.plus;

const CURRENCY_BY_COUNTRYID = {
    225: 'RUB',
    159: 'KZT',
    149: 'BYN',
    171: 'UZS',
    167: 'AZN',
    168: 'AMD',
    208: 'MDL',
    207: 'RUB',
    169: 'RUB',
    209: 'RUB',
    10099: 'RUB',
    181: 'ISL',
    170: 'USD',
    983: 'USD'
};

module.exports = (req, res) => {
    const uid = req._controller.getAuth().getUid();

    if (process.env.INTRANET === 'intranet') {
        return res.json({status: 'ok', state: 'is-intranet'});
    }

    if (!uid) {
        return res.json({status: 'ok', state: 'no-auth'});
    }

    // Убираем для стран без плюса PASSP-36817
    if (!isFamilyEnable(res.locals.countryId)) {
        return res.json({status: 'ok', state: 'no-country-plus'});
    }

    const serviceTicket = req.serviceTickets && req.serviceTickets[tvm.SERVICE_ALIASES.TRUSTAPI];

    return new TrustApiApi(req.logID, req.userTicket, serviceTicket)
        .getPlusWalletBalance(uid)
        .then(({balances = []}) => {
            if (!balances.length) {
                return {state: 'no-payment-method'};
            }

            const curCountryCurrency = CURRENCY_BY_COUNTRYID[res.locals.countryId];
            const curBalanceIndex = curCountryCurrency
                ? Math.max(
                      balances.findIndex((i) => i.currency === curCountryCurrency),
                      0
                  )
                : 0;
            const {amount} = balances[curBalanceIndex];
            const balance = Math.floor(Number(amount));

            return balance ? {state: 'ok', balance: Number(balance)} : {state: 'no-balance'};
        })
        .catch(() => ({state: 'error'}))
        .then((balance) =>
            res.json({
                ...balance,
                plusLink: plusLink && `//${plusLink.replace('%tld%', req._controller.getTld())}?from=yandexid`
            })
        );
};
