const PLog = require('plog');
const apiSetup = require('./apiSetup');
const writeTrack = require('./writeTrack');
const {getScenarioByProcess} = require('../authv2/getScenarioByProcess');

module.exports = function getTrack(initParams = {}, isInit = false) {
    return [
        apiSetup,
        (req, res, next) => {
            const requestParams = {...initParams};
            const {body: {isAm, appId, track_id, process} = {}} = req;

            res.locals.track_id = res.locals.track_id || track_id || (req.nquery && req.nquery.track_id) || '';

            if (res.locals.track_id) {
                return next();
            }

            if (process) {
                requestParams.scenario = getScenarioByProcess(process);
            }

            if (isAm && appId) {
                requestParams.app_id = appId;
            }

            return req.api
                .getTrack(requestParams, isInit)
                .then(function(response) {
                    const {body = {}} = response;

                    res.locals.track_id = (isInit ? body.track_id : body.id) || '';
                    return next();
                })
                .catch(function(errors) {
                    PLog.warn()
                        .logId(req.logID)
                        .type('getTrack')
                        .write(errors);

                    return next();
                });
        },
        writeTrack
    ];
};
