const PLog = require('plog');

module.exports = function getUatraitsData(req, res, next) {
    if (res.locals.ua) {
        return next();
    }

    return req._controller
        .getUatraits()
        .then(function(response) {
            res.locals.ua = response;

            return next();
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type('common.getUtraitsData')
                .write(err);

            return next();
        });
};
