const encrypt = require('yandex-clck-url/libs/encrypt');
const PLog = require('plog');
const metricsKey = Buffer.from('jQm9NqfREKGKRNgHSGLV1A==', 'base64');

module.exports = function getYaExperimentsFlags(req, res, next) {
    if (typeof res.locals.experiments !== 'undefined') {
        return next();
    }

    return req._controller
        .getYaExperimentInfoPromise()
        .then(function(experiments) {
            const flags = experiments.flags;
            const flagsString = (Array.isArray(flags) && flags.join(',')) || '';
            const boxes = experiments.boxes || [];
            const encodedBoxes = boxes ? encrypt(boxes.join(';'), metricsKey) : '';

            res.locals.experiments = {
                flags,
                flagsString,
                boxes,
                encodedBoxes
            };

            return next();
        })
        .catch(function(err) {
            PLog.warn()
                .logId(req.logID)
                .type('common.getYaExperimentsFlags')
                .write(err);

            return next();
        });
};
