var config = require('../../configs/current');
var morgan = require('morgan');
var Logger = require('plog');
var loc = require('../../loc/auth');
var when = require('when');
var getYaExperimentsFlags = require('./getYaExperimentsFlags');
var HttpError = require('http-errors').HttpError;

var errTitle = {
    internal: 'complaine.head',
    registrationalreadycompletederror: 'ErrorsTexts.title.error',
    notavailable: 'ErrorsTexts.title.error',
    sessionoverflowerror: 'ErrorsTexts.sessionidoverflow_reg',
    notfound: 'ErrorsTexts.notfound'
};

var errDesc = {
    internal: 'Complains.badrequest',
    registrationalreadycompletederror: 'MendTexts.registrationalreadycompletederror',
    notavailable: 'MendTexts.registrationalreadycompletederror',
    sessionoverflowerror: 'MendTexts.sessionidoverflow_reg',
    notfound: 'MendTexts.notfound'
};

module.exports = function(app) {
    app.use(function(err, req, res, next) {
        if (!res.err) {
            res.err = err;
        }
        morgan(':localdate ERROR frontend :logID :track_id :method :url :body :err', {
            stream: process.stderr,
            immediate: true
        })(req, res, function() {
            next(err);
        }); //TODO: remove me (PASSP-9509), call next(err) manually
    });

    app.use(function(err, req, res, next) {
        if (res.headersSent) {
            return next(err);
        }

        var controller = req._controller;

        if (err instanceof HttpError) {
            return controller
                .getLanguage()
                .then(function(lang) {
                    res.locals.language = lang;
                })
                .catch(function() {
                    res.locals.language = 'ru';
                })
                .then(function() {
                    res.status(err.status).render(`error.${res.locals.language}.js`, {});
                })
                .catch(next);
        } else {
            return next(err);
        }
    });

    app.use(function(err, req, res, next) {
        if (err instanceof URIError) {
            Logger.info()
                .logId(req.logID)
                .type('passport', 'app', '404')
                .write(err);

            if (res.headersSent) {
                return next(err);
            }

            return res.redirect(config.paths.retpath);
        } else {
            return next(err);
        }
    });

    app.use(function(err, req, res, next) {
        /*jshint unused:false*/
        Logger.error()
            .logId(req.logID)
            .type('passport', 'app', 'errlog')
            .write(err);
        if (res.headersSent) {
            return next(err);
        }

        var errCode = err[0] && err[0].code;
        var data = {
            env: app.get('env'),
            retpath: config.paths.retpath,
            logID: req.logID,
            statusCode: 500,
            date: new Date().toString(),
            error: {
                code: errCode
            }
        };

        if ('development' === data.env) {
            data.error.name = err.name;
            data.error.msg = err.stack || JSON.stringify(err);

            return res.status(data.statusCode).render('error.ru.js', data);
        }

        var controller = req._controller;

        when.resolve()
            .then(function() {
                return controller.getLanguage();
            })
            .then(function(lang) {
                res.locals.language = lang || 'ru';
                return loc[res.locals.language];
            })
            .catch(function() {
                res.locals.language = 'ru';
                return loc[res.locals.language];
            })
            .then(function(locs) {
                if (!(errCode in errTitle) && !(errCode in errDesc)) {
                    errCode = 'internal';
                }

                data.error.name = null;
                data.error.msg = null;

                if (locs) {
                    data.error.name = locs['Errors'][errTitle[errCode]] || locs['common'][errTitle[errCode]] || null;
                    data.error.msg = locs['Mend'][errDesc[errCode]] || locs['common'][errDesc[errCode]] || null;
                }

                if (errCode === 'captchalocate') {
                    data.statusCode = 400;
                }

                res.status(data.statusCode).render(`error.${res.locals.language}.js`, data);
            })
            .catch(next);
    });

    if ('development' !== app.get('env')) {
        app.use(function(err, req, res, next) {
            /*jshint unused:false*/
            Logger.critical()
                .logId(req.logID)
                .type('passport', 'app', 'fallbackErrorHandler')
                .write('Error while sending 500 code:', err);

            if (res.headersSent) {
                return next(err);
            }

            res.status(500).send(
                '<html><body>Критическая ошибка, мы о ней уже знаем и займемся в ближайшее время.<br />Critical ' +
                    'error. We already know about it and would handle it shortly.</body></html>'
            );
        });
    }

    // 404
    app.get('*', [
        morgan(':localdate WARN notfound :logID :track_id :method :url :status [:response-time ms]', {
            stream: process.stderr
        }), //TODO: remove me (PASSP-9509)
        getYaExperimentsFlags,
        function(req, res, next) {
            var controller = req._controller;

            if (res.headersSent) {
                Logger.error()
                    .logId(req.logID)
                    .type('passport', 'app', '404')
                    .write(
                        '404 Page not found, but headers were sent: %s %s',
                        controller.getMethod(),
                        controller.getUrl().href
                    );

                return next('route');
            }

            Logger.info()
                .logId(req.logID)
                .type('passport', 'app', '404')
                .write('404 Page not found: %s %s', controller.getMethod(), controller.getUrl().href);

            var data = {
                env: app.get('env'),
                retpath: config.paths.retpath,
                logID: req.logID,
                statusCode: 404,
                date: new Date().toString(),
                error: {
                    code: 'notfound'
                }
            };

            when.resolve()
                .then(function() {
                    return controller.getLanguage();
                })
                .then(function(lang) {
                    res.locals.language = lang || 'ru';
                    return loc[res.locals.language];
                })
                .catch(function() {
                    res.locals.language = 'ru';
                    return loc[res.locals.language];
                })
                .done(function(locs) {
                    data.error.name = locs['Errors'][errTitle[data.error.code]] || null;
                    data.error.msg = locs['Mend'][errDesc[data.error.code]] || null;

                    res.status(data.statusCode).render(`error.${res.locals.language}.js`, data);
                });
        }
    ]);
};
