const neoPhonish = require('./getCustomConfig')('customs.neophonish.config.json');

module.exports = (experimentsFlags, origin) => {
    const {origins = [], originsMask = [], originsAB = [], originsMaskAB = [], excludedOrigins = []} = neoPhonish;
    const isNeoPhonishExp = experimentsFlags.includes('domik-neophonish-exp-enable');

    const realOrigin = Array.isArray(origin) ? origin[0] : typeof origin === 'string' ? origin : '';

    if (!realOrigin || !isNeoPhonishExp || excludedOrigins.includes(realOrigin)) {
        return false;
    }

    const isNeoPhonishOriginsABExp = experimentsFlags.includes('domik-neophonish-exp-ab-enable');
    const isNeoPhonishOriginsABDesktopExp = experimentsFlags.includes('domik-neophonish-exp-ab-control-desktop');

    // 100%
    const isAvailableOrigin = origins.includes(realOrigin);
    const isAvailableOriginMask = Boolean(originsMask.filter((mask) => realOrigin.startsWith(mask)).length);

    // AB
    const isAvailableOriginAB = originsAB.includes(realOrigin);
    const isAvailableOriginMaskAB = Boolean(originsMaskAB.filter((mask) => realOrigin.startsWith(mask)).length);

    // @see https://st.yandex-team.ru/PASSP-28818
    return (
        isAvailableOrigin ||
        isAvailableOriginMask ||
        ((isNeoPhonishOriginsABExp || isNeoPhonishOriginsABDesktopExp) &&
            (isAvailableOriginAB || isAvailableOriginMaskAB))
    );
};
