module.exports = function isUnsupportedBro(ua) {
    const broVersion = parseInt(ua.BrowserVersion, 10);
    const broName = ua.BrowserName;

    if (ua.OSFamily === 'Tizen') {
        return true;
    }

    if (ua.isMobile) {
        if (broName === 'MobileSafari' && broVersion <= 7) {
            return true;
        }

        if (broName === 'OperaMini') {
            return true;
        }

        if (broName === 'UCWEB') {
            return true;
        }

        if (broName === 'AndroidBrowser' && parseFloat(ua.OSVersion, 10) < 5) {
            return true;
        }

        if (ua.BrowserName === 'Samsung Internet' && broVersion <= 4) {
            return true;
        }
    } else {
        if (ua.BrowserName === 'Firefox' && broVersion <= 42) {
            return true;
        }

        if (ua.BrowserName === 'MSIE' && broVersion <= 10) {
            return true;
        }

        if (ua.BrowserName === 'Safari' && broVersion <= 5) {
            return true;
        }
    }

    return false;
};
