const PLog = require('plog');

module.exports = function langSetup(req, res, next) {
    if (res.locals.language) {
        return next();
    }

    return req._controller
        .getLanguage()
        .then(function(lang) {
            res.locals.language = lang;
        })
        .catch(function(err) {
            res.locals.language = 'ru';

            PLog.warn()
                .logId(req.logID)
                .type('common.langSetup')
                .write(err);
        })
        .then(function() {
            return next();
        });
};
