const PLog = require('plog');
const apiSetup = require('./apiSetup');

function getQuestions(logType = 'common.getQuestions') {
    return (req, res, next) => {
        return req.api
            .getQuestions()
            .then((response) => {
                res.locals.questions = response.body.questions;

                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type(logType)
                    .write(errors);

                return next();
            });
    };
}

module.exports = {
    loadQuestions: [apiSetup, getQuestions('registration.v2')],
    getQuestions
};
