var config = require('../../configs/current');
var _ = require('lodash');
var punycode = require('punycode');
var locs = require('../../loc/multiauth');
var PLog = require('plog');
var corsAllowed = config.corsAllowed;
var util = require('util');
var allowedLangs = config.langs;
const urlParse = require('./urlFormat').urlParse;
const urlFormat = require('./urlFormat').urlFormat;

var errorsMapping = {
    DISABLED: 'account.disabled',
    INVALID: 'session.invalid'
};

var tldToLang = {
    ru: 'ru',
    com: 'en',
    ua: 'uk',
    'com.tr': 'tr'
};

module.exports = {};
module.exports.route = function(app) {
    var self = this;
    var method = 'json';

    app.get(
        '/accounts-info',
        function(req, res, next) {
            var nquery = req.nquery;

            if (!nquery.yu || nquery.yu !== req.cookies.yandexuid) {
                res[method]({});
            } else {
                if (nquery.lang) {
                    res.localLang = allowedLangs[allowedLangs.indexOf(nquery.lang)] || 'ru';
                }
                next();
            }
        },
        self.getAccounts,
        function(req, res) {
            var origin = req.headers.origin;

            if (corsAllowed === '*' || (util.isArray(corsAllowed) && corsAllowed.indexOf(origin) > -1)) {
                if (origin) {
                    res.setHeader('Access-Control-Allow-Origin', origin);
                }
                res.setHeader('Access-Control-Allow-Methods', 'GET');
                res.setHeader('Access-Control-Allow-Credentials', 'true');
            }

            res.json(res.locals.accounts || {});
        }
    );
};

module.exports.getAccounts = [
    function(req, res, next) {
        var controller = req._controller;
        var auth = controller.getAuth();

        req._logger = new PLog(req.logID, 'accounts-info');

        // Не ходим второй раз, если незалогинены
        // if (res.locals.availableIds.length === 0) {
        //     return next();
        // }

        // Не ходим второй раз, если нет запиненного uid
        // if (!req.query.uid) {
        //     return next();
        // }

        return auth
            .sessionID({
                multisession: 'yes',
                full_info: 'yes',
                get_family_info: 'yes',
                get_public_id: 'yes',
                get_public_name: 'yes',
                is_display_name_empty: 'yes',
                attributes: `27,28,34,1011,181,182,184,187,200,1005,1023,1024${
                    res.locals.blackboxPlus ? ',160,161,162,163,164,1015,1022' : ''
                }`,
                emails: 'getdefault',
                getphones: 'bound',
                phone_attributes: process.env.INTRANET === 'intranet' ? undefined : '4,108',
                // https://wiki.yandex-team.ru/passport/dbmoving/#tipyaliasov
                aliases: 'all'
            })
            .then(function(sessioninfo) {
                req.blackbox = sessioninfo || {};
                return next();
            })
            .catch(function(error) {
                // eslint-disable-line consistent-return
                if (error && error.code === 'need_resign') {
                    if (req.method === 'POST') {
                        return next();
                    }

                    return auth.resign();
                }

                if (error && error instanceof Error) {
                    return next(error);
                }
            });
    },
    function(req, res, next) {
        // eslint-disable-line consistent-return
        if (!req.blackbox || !req.blackbox.users) {
            req._logger.info('Blackbox responsed with zero users');
            return next();
        }

        if (req.blackbox.initial_default_uid !== req.blackbox.default_uid) {
            const embeddedauthObj = urlParse(
                `https:${config.paths.embeddedauth.replace('%tld%', req._controller.getTld())}`
            );

            return res.redirect(
                urlFormat({
                    ...embeddedauthObj,
                    query: {
                        ...embeddedauthObj.query,
                        action: 'change_default',
                        origin: req.query.origin,
                        uid: req.blackbox.default_uid,
                        retpath: urlFormat(req._controller.getUrl()),
                        yu: res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '')
                    }
                })
            );
        }

        var tld = req._controller.getTld();
        var langdetect = req.langdetect || {};
        var lang =
            (res.locals && res.locals.language) || langdetect.id || res.localLang || (tld && tldToLang[tld]) || 'ru';
        var loc = locs[lang] ? locs[lang].dropdown : locs.en.dropdown;
        var mode = (req.nquery && req.nquery.mode) || req.query.mode;
        var avatarPaths = config.paths.avatar;
        var users = {
            'can-add-more': req.blackbox.allow_more_users,
            default_uid: req.blackbox.default_uid,
            accounts: [],
            defaultAccount: {}
        };

        // if (res.locals.availableIds.indexOf(req.blackbox.default_uid) !== -1) {
        // users.default_uid = req.blackbox.default_uid;
        // }

        req.blackbox.users.forEach(function(item = {}) {
            const {
                auth = {},
                aliases = {},
                display_name: displayName = {},
                uid = {},
                id,
                status = {},
                login,
                regname,
                attributes = {}
            } = item;
            const user = {
                uid: uid.value || id,
                isPDD: Boolean(uid.hosted),
                is_yandexoid: aliases.hasOwnProperty('13'),
                isYandexoid: aliases.hasOwnProperty('13'),
                isScholar: aliases.hasOwnProperty('23'),
                isFederal: aliases.hasOwnProperty('24'),
                passwordVerificationAge: (auth.password_verification_age || 0) * 1000 || -1,
                isNeoPhonish: aliases.hasOwnProperty('21') && !aliases.hasOwnProperty('1'),
                isSocial: aliases.hasOwnProperty('6') && !aliases.hasOwnProperty('1'),
                hasPublicProfile: displayName.has_public_profile,
                hasThirdPartyAccess: displayName.third_party_can_use
            };
            const phone = (item.phones || []).find(({attributes = {}} = {}) => attributes[108] === '1');

            if (item.id /* &&res.locals.availableIds.indexOf(item.id) !== -1*/) {
                user.avatarId = (displayName.avatar && displayName.avatar.default) || user.uid;
                user.status = status.value;
                user.login = _.escape(login) || _.escape(regname) || '';
                user.unescaped = {};

                // почта
                if (item['address-list'] && item['address-list'].length) {
                    user.mail = item['address-list'][0].address || '';
                    if (user.mail !== '') {
                        var mail = user.mail.split('@');

                        user.mail = _.escape([mail[0], punycode.toUnicode(mail[1])].join('@'));
                    }
                }

                // имя и фамилия пользователя
                if (attributes[27] || attributes[28]) {
                    user.name = [attributes[27], attributes[28]].join(' ');
                } else {
                    user.name = displayName.name || '';
                }

                user.loginOptions = {
                    qrCodeLoginForbidden: Boolean(attributes[182]),
                    smsCodeLoginForbidden: Boolean(attributes[187])
                };

                user.havePassword = Boolean(attributes && attributes[1005]);
                user.hasPublicIdSet = Boolean(attributes && attributes[1024]);
                user.suggestedPublicName = attributes && attributes[1023];
                user.unescaped.name = user.name;
                user.name = _.escape(user.name);

                if (status.value === 'INVALID' && !uid.value) {
                    user.status = 'DELETED';
                    user.deleted = loc.user_deleted;
                }

                user.displayName = displayName.name || '';
                user.isDisplayNameEmpty = Boolean(displayName.display_name_empty);
                user.publicDisplayName = displayName.public_name || '';
                user.isVerified = displayName.verified;

                if (displayName.social) {
                    const {profile_id: profileId, provider} = displayName.social || {};

                    if (profileId && provider) {
                        user.social = {profileId, provider};
                    }
                }

                user.hasPhone = (item.phones || []).length > 0;
                user.hasPlus = attributes[1015] === '1';
                user.lastPhoneConfirmation = !phone ? -1 : Number(phone.attributes[4] || 0) * 1000;

                users.accounts.push(user);
                if (user.uid === req.blackbox.default_uid) {
                    user.is_liteUser = aliases.hasOwnProperty('5') && !aliases.hasOwnProperty('1');
                    users.defaultAccount = user;
                    res.locals.isWSUser = Boolean(attributes[1011]);
                    if (res.locals.blackboxPlus && !item.attributes) {
                        users.defaultAccount.plus = {};
                    } else if (res.locals.blackboxPlus) {
                        users.defaultAccount.plus = {
                            enabled: attributes[1015] === '1',
                            enabledTime: Number(attributes[160] || 0) * 1000,
                            trialUsedTime: Number(attributes[161] || 0) * 1000,
                            subscriptionStoppedTime: Number(attributes[162] || 0) * 1000,
                            subscriptionExpireTime: Number(attributes[163] || 0) * 1000,
                            nextChargeTime: Number(attributes[164] || 0) * 1000,
                            familySubType: (attributes[1022] || '').toUpperCase() || undefined
                        };
                    }
                }
            }
        });

        if (
            users.defaultAccount.status &&
            errorsMapping[users.defaultAccount.status] &&
            !res.rawErrors &&
            res.locals &&
            !res.locals.state
        ) {
            res.rawErrors = [errorsMapping[users.defaultAccount.status]];
        }

        res.locals = _.extend(res.locals, {
            accounts: users,
            loginStatusRetpath: `${req.headers['x-real-scheme']}://${req.hostname}${config.paths.loginStatusPath}`,
            avatarRoofUrl: `${req.headers['x-real-scheme']}://${avatarPaths.host}${avatarPaths.pathname.replace(
                '%size%',
                process.env.INTRANET === 'intranet' ? '80' : '75'
            )}`,
            avatarUrl: `${req.headers['x-real-scheme']}://${avatarPaths.host}${avatarPaths.pathname.replace(
                '%size%',
                process.env.INTRANET === 'intranet' ? '42' : 'middle'
            )}`
        });

        if (!users.defaultAccount.uid) {
            res.locals.mode = 'add-user';
        }

        if (mode && ['edit', 'add-user'].indexOf(mode) !== -1) {
            res.locals.mode = mode;
        }

        next();
    }
];
