const isValid = require('./checkAuth/isValid');
const getDefaultUser = require('./checkAuth/getDefaultUser');
const url = require('url');
const config = require('../../configs/current');
const PLog = require('plog');
const getUatraitsData = require('./getUatraitsData');
const lookup = require('../../lib/getLookup.js');

function getDefaultUserData(sessionInfo) {
    const defaultUid = sessionInfo.default_uid;
    const users = sessionInfo.users;
    const defaultUser = getDefaultUser(users, defaultUid);
    const isYandexoid = defaultUser && defaultUser.aliases && defaultUser.aliases.hasOwnProperty('13');
    const hasPlus = defaultUser && defaultUser.attributes && defaultUser.attributes['1015'] === '1';

    return {
        isYandexoid,
        hasPlus
    };
}

const checkRegion = (req, res) =>
    new Promise((resolve, reject) => {
        const {country, regionId, countryId, plusAvailableCountries} = res.locals;
        const countries = plusAvailableCountries || config.plusAvailableCountries;

        if (!regionId || (countryId !== undefined && !countryId)) {
            return reject();
        }

        if (countryId && country && countries[countryId] === country) {
            return resolve();
        }

        try {
            if (!countries[countryId || lookup.getCountryId(regionId, req._controller.getTld())]) {
                return reject();
            }

            return resolve();
        } catch (e) {
            return reject();
        }
    });

const checkTld = (req, res) =>
    new Promise((resolve, reject) => {
        const controller = req._controller;
        const tld = controller.getTld();
        const plusAvailableTld = res.locals.plusAvailableTld || config.plusAvailableTld;

        if (plusAvailableTld.indexOf(tld) === -1) {
            return reject({
                status: 'error',
                tld
            });
        }

        return resolve({
            status: 'ok',
            tld
        });
    });

const getUserData = (req) =>
    new Promise((resolve, reject) => {
        const controller = req._controller;
        const auth = controller.getAuth();

        auth.sessionID({
            multisession: 'yes',
            full_info: 'yes',
            get_family_info: 'yes',
            get_public_id: 'yes',
            get_public_name: 'yes',
            attributes: '27,28,34,1011,160,161,162,163,164,1015',
            emails: 'getdefault',
            getphones: 'bound',
            aliases: '13'
        })
            .then((sessionInfo) => {
                if (isValid(sessionInfo)) {
                    const userData = getDefaultUserData(sessionInfo);

                    return resolve(
                        Object.assign(
                            {},
                            {
                                status: 'ok'
                            },
                            userData
                        )
                    );
                }

                return reject({
                    status: 'error',
                    userIsValid: false
                });
            })
            .catch((error) =>
                reject({
                    status: 'error',
                    error
                })
            );
    });

module.exports.guard = [
    (req, res, next) =>
        checkTld(req, res)
            .then(() => next())
            .catch((err) => {
                PLog.info()
                    .logId(req.logID)
                    .type('plusGuard.guard')
                    .write(err);

                return req._controller.redirect(
                    url.format({
                        protocol: 'https',
                        hostname: config.paths.passport.replace('%tld%', req._controller.getTld()),
                        pathname: 'profile'
                    })
                );
            }),

    // eslint-disable-next-line no-unused-vars
    (err, req, res, next) => {
        PLog.info()
            .logId(req.logID)
            .type('plusGuard.guard')
            .write(err);

        return req._controller.redirect(
            url.format({
                protocol: 'https',
                hostname: config.paths.passport.replace('%tld%', req._controller.getTld()),
                pathname: 'profile'
            })
        );
    }
];

function showPlusAndNext(res, next) {
    res.locals.showPlus = true;

    return next();
}

module.exports.showPlus =
    process.env.INTRANET === 'intranet'
        ? (req, res, next) => next()
        : [
              getUatraitsData,
              function(req, res, next) {
                  if (typeof res.locals.showPlus !== 'undefined') {
                      return next();
                  }

                  if (res.locals.ua && res.locals.ua.isRobot) {
                      return showPlusAndNext(res, next); // Проходим дальше, в плюс
                  }

                  return next();
              },
              function(req, res, next) {
                  if (typeof res.locals.showPlus !== 'undefined') {
                      return next();
                  }

                  return checkTld(req, res)
                      .then(() => next())
                      .catch(next);
              },
              function(req, res, next) {
                  if (typeof res.locals.showPlus !== 'undefined') {
                      return next();
                  }

                  return getUserData(req, res)
                      .then((user) => {
                          if (user.isYandexoid) {
                              return showPlusAndNext(res, next); // Проходим дальше, в плюс
                          }

                          throw new Error('no yandexoid');
                      })
                      .catch(() => next());
              },
              function(req, res, next) {
                  if (typeof res.locals.showPlus !== 'undefined') {
                      return next();
                  }

                  return checkRegion(req, res)
                      .then(() => showPlusAndNext(res, next)) // Проходим дальше, в плюс
                      .catch(() => next());
              },
              function(req, res, next) {
                  if (typeof res.locals.showPlus !== 'undefined') {
                      return next();
                  }

                  return getUserData(req, res)
                      .then((user) => {
                          if (user.hasPlus) {
                              return showPlusAndNext(res, next); // Проходим дальше, в плюс
                          }

                          throw new Error('no plusUser');
                      })
                      .catch(() => next());
              },
              function(req, res, next) {
                  if (typeof res.locals.showPlus !== 'undefined') {
                      return next();
                  }
                  PLog.info()
                      .logId(req.logID)
                      .type('showPlusCheck')
                      .write('wrong Region and no plus or yandex');

                  res.locals.showPlus = false;
                  return next();
              },
              function(err, req, res, next) {
                  PLog.info()
                      .logId(req.logID)
                      .type('showPlusCheck')
                      .write(err);
                  res.locals.showPlus = false;

                  return next();
              }
          ];
