const url = require('url');
const querystring = require('querystring');

module.exports = (
    fallbackRetpath = '',
    {
        status,
        yandex_authorization_code: yandexAuthorizationCode,
        profile_id: profileId,
        return_brief_profile: returnBriefProfile,
        x_token: xToken,
        token,
        account = {},
        retpath = ''
    }
) => {
    const isAM = !retpath.includes('i-social__closer');
    const parsedRetpath = url.parse(isAM ? retpath : fallbackRetpath);
    const params = {
        status,
        am_social: isAM
    };

    if (yandexAuthorizationCode) {
        params.yandex_authorization_code = yandexAuthorizationCode;
    }

    if (profileId && returnBriefProfile) {
        params['profile.profile_id'] = profileId;
    }

    if (xToken || token) {
        if (xToken) {
            params.x_token = xToken;
        }

        if (token) {
            params.token = token;
        }

        if (account.uid) {
            params.uid = account.uid;
        }

        if (account.login) {
            params.login = account.login;
        }

        if (account.display_name && account.display_name.name) {
            params.display_name = account.display_name.name;
        }
    }

    parsedRetpath.search = null;

    if (parsedRetpath.query) {
        parsedRetpath.query = querystring.parse(parsedRetpath.query);
        parsedRetpath.query = Object.assign({}, parsedRetpath.query, params);
    } else {
        parsedRetpath.query = params;
    }

    parsedRetpath.hash = querystring.stringify(params);

    return url.format(parsedRetpath);
};
