const PLog = require('plog');

module.exports = (req, res, next) => {
    req.api
        .profileGetState()
        .then((response = {}) => {
            const {body = {}} = response;
            const {account = {}} = body;

            res.locals.account = account;

            return next();
        })
        .catch((error) => {
            PLog.warn()
                .logId(req.logID)
                .type('common.profileStateSetup')
                .write(error);
            return next();
        });
};
