const config = require('../../configs/current');
const getCustomConfig = require('./getCustomConfig');
const customsLocs = getCustomConfig('customs.json', 'locs');
const authCustomsVersion = getCustomConfig('customs.version.json').version;
const {filterProviders} = require('../utils');
const authCustomsStatic = config.paths.authCustomsStatic;

const setFieldWithLocs = (config, store, lang, key, cb) => {
    if (config[key]) {
        const value = customsLocs[lang] && customsLocs[lang][config[key]];

        if (value) {
            store[key] = value;
            cb && cb(value);
        }
    }
};

const setField = (config, store, key, isRaw = false, cb) => {
    if (config[key]) {
        const value = !isRaw || config[key];

        store[key] = value;
        cb && cb(value);
    }
};

const getExtraBgNumber = (bgCount) =>
    bgCount > 1 ? (Math.floor(new Date().getTime() / 1000 / 60 / 10) % bgCount) + 1 : '';

module.exports = function putCustomsFieldsInStore(
    originalConfig,
    store = {},
    isNeoPhonishRegisterAvailable,
    flags,
    lang
) {
    const customsStore = store.customs || (store.customs = {});
    const commonStore = store.common || (store.common = {});
    const settingsStore = store.settings || (store.settings = {});

    commonStore.bgNumber = getExtraBgNumber(18);
    customsStore.bgNumber = commonStore.bgNumber;
    settingsStore.authCustomsVersion = authCustomsVersion;
    settingsStore.authCustomsStatic = authCustomsStatic;

    if (originalConfig) {
        const config = {...originalConfig};

        if (config.exps) {
            Object.keys(config.exps).forEach((expName) => {
                if (flags.includes(expName)) {
                    Object.assign(config, originalConfig.exps[expName]);
                }
            });
        }

        if (
            originalConfig.environments &&
            originalConfig.environments[process.env.NODE_ENV] &&
            typeof originalConfig.environments[process.env.NODE_ENV] === 'object'
        ) {
            Object.assign(config, originalConfig.environments[process.env.NODE_ENV]);
        }

        const socialStore = store.social || (store.social = {});

        if (Array.isArray(originalConfig.providers) && Array.isArray(socialStore.providers)) {
            socialStore.providers = socialStore.providers.filter(filterProviders(originalConfig.providers));
        }

        // Текстовые поля с локализацией
        setFieldWithLocs(config, customsStore, lang, 'tagline');
        setFieldWithLocs(config, customsStore, lang, 'taglinePassword');
        // Флажки
        setField(config, customsStore, 'allowScholar');
        setField(config, customsStore, 'hideForgetLoginLink');
        setField(config, customsStore, 'hideForgetLoginLinkUntilShowLoginError');
        setField(config, customsStore, 'hidePasswordAccountSuggest');
        setField(config, customsStore, 'hideForgetPasswordLink');
        setField(config, customsStore, 'hideYaIdPromo');
        setField(config, customsStore, 'hideNeophonishOtherAccountLink');
        setField(config, customsStore, 'hideQrButton');
        setField(config, customsStore, 'hideRegButton');
        setField(config, customsStore, 'hideRegButtonUntilShowLoginError');
        setField(config, customsStore, 'hideTagline');
        setField(config, customsStore, 'showWebviewCloser');
        setField(config, customsStore, 'socialExtended');
        setField(config, customsStore, 'socialButtonsWithText');
        setField(config, customsStore, 'minimal');
        setField(config, customsStore, 'isSkipEulaPage');
        setField(config, customsStore, 'isKeyEnabled2FA');
        setField(config, customsStore, 'isEmailOnly');
        setField(config, customsStore, 'bgNoDarken');
        setField(config, customsStore, 'hideSocialBlock');
        setField(config, customsStore, 'hideAuthLoginInputToggle');
        // Поля кладущиеся в стор как есть
        setField(config, customsStore, 'completeReg', true);
        setField(config, customsStore, 'noPrevStepButton', true);
        setField(config, customsStore, 'buttonView', true);
        setField(config, customsStore, 'autoRuButton', true);
        setField(config, customsStore, 'yaIdType', true);
        setField(config, customsStore, 'bgColor', true);
        setField(config, customsStore, 'hideRegistration', true);
        setField(config, customsStore, 'bgNumber', true, (bgNumber) => {
            const number = `${bgNumber}${getExtraBgNumber(config.bgCount)}`;

            customsStore.bgNumber = number;
            commonStore.bgNumber = number;
        });
        setField(config, customsStore, 'whitelabel', true, () => {
            customsStore.isWhiteLabel = true;
        });
        setField(config, customsStore, 'fullscreen', true, () => {
            customsStore.isFullScreen = true;
        });
    }

    if (isNeoPhonishRegisterAvailable) {
        customsStore.isNeoPhonishRegisterAvailable = true;
    }
};
