const PLog = require('plog');
const config = require('../../configs/current');
const RegController = require('../../lib/controller/RegistrationController');
const getConnectRegistrationData = (req) => {
    const data = {
        track_id: req.body.track_id,
        firstname: req.body.firstname,
        lastname: req.body.lastname,
        domain: `${req.body.domain}.${config.workspace.zone.replace('%TLD%', req._controller.getTld())}`,
        login: req.body.login.trim(),
        password: req.body.password,
        eula_accepted: req.body.eula_accepted,
        force_clean_web: req.body.force_clean_web,
        organization: req.body.domain
    };

    if (req.body.keepUnsubscribedValue) {
        data.keepUnsubscribedValue = req.body.keepUnsubscribedValue;
    }

    if (req.body.origin) {
        data.origin = req.body.origin;
    }

    return data;
};
const getRegistrationHandler = (regType) => {
    const registrationHandlers = {
        default: 'accountRegisterAlternative',
        lite: 'accountRegisterWithEmail',
        'lite-experiment': 'accountRegisterExperimentEmailCommit',
        connect: 'workspaceRegistration',
        neophonish: 'neoPhonishAccountRegister'
    };

    return registrationHandlers[regType] || registrationHandlers.default;
};

module.exports = function registerNewAccount(req, res, next) {
    const registrationHandler = getRegistrationHandler(res.locals.regType);
    const isConnectRegistration = registrationHandler === 'workspaceRegistration';
    const data = isConnectRegistration ? getConnectRegistrationData(req) : req.body;

    if (res.locals.gender) {
        data.gender = res.locals.gender;
    }

    req._controller
        .suggestLanguage()
        .then((suggestedLanguage) => {
            if (suggestedLanguage) {
                data.language = suggestedLanguage;
            }

            if (registrationHandler === 'accountRegisterAlternative' && data['human-confirmation'] !== 'phone') {
                PLog.info()
                    .logId(req.logID)
                    .type('registerAccount')
                    .write(`trying to register with ${data['human-confirmation']}`);

                return res.json({status: 'error', error: ['validation_method.invalid']});
            }

            req.api[registrationHandler](data)
                .then((response) => {
                    if (response.body && response.body.status === 'ok') {
                        PLog.info()
                            .logId(req.logID)
                            .type('registerAccount')
                            .write('registering account');
                    }
                })
                .then(() => {
                    const reqistratonController = new RegController(req, res, req.logID);

                    if (data.from && data.from === 'galatasaray') {
                        req._controller.readTrack().then((trackContents) => {
                            if (trackContents.uid) {
                                PLog.info()
                                    .logId(req.logID)
                                    .type('registerAccount')
                                    .write('Subscribe from=galatasaray to 61');
                                reqistratonController.accountSubscribe({
                                    uid: trackContents.uid,
                                    service_slug: 'galatasaray'
                                });
                            }

                            return next();
                        });
                    } else {
                        return next();
                    }
                })
                .catch((error) => {
                    PLog.warn()
                        .logId(req.logID)
                        .type('registerAccount')
                        .write(`registration ${res.locals.regType}`, JSON.stringify(error));

                    return res.json({status: 'error', error});
                });
        })
        .catch((error) => {
            PLog.warn()
                .logId(req.logID)
                .type('suggestLanguage')
                .write(`registration ${res.locals.regType}`, JSON.stringify(error));

            return res.json({status: 'error', error});
        });
};
