const when = require('when');
const PLog = require('plog');
const RegController = require('../../lib/controller/RegistrationController');
const createSessionWithoutAJAX = require('./createSessionWithoutAJAX');

module.exports = function registerAccountWithoutAJAX(req, res, next) {
    const data = req.body;

    const deffered = when.defer();

    let suggestPromise;

    if ((data.firstname && data.lastname) || data.surname) {
        suggestPromise = req._controller
            .suggestGender(data.firstname, data.lastname || data.surname, true)
            .then(function(gender) {
                if (gender) {
                    data.gender = gender;
                }
            });
    } else {
        deffered.resolve();
        suggestPromise = deffered.promise;
    }

    return suggestPromise
        .then(function() {
            return req.api
                .accountRegisterAlternative(data)
                .then(function(response) {
                    if (response.body && response.body.status === 'ok') {
                        PLog.info()
                            .logId(req.logID)
                            .type('registration.v2')
                            .write('registering account');
                    }
                })
                .then(function() {
                    const registrationController = new RegController(req, res, req.logID);

                    if (data.from && data.from === 'galatasaray') {
                        return req._controller.readTrack().then(function(trackContents) {
                            if (trackContents.uid) {
                                PLog.info()
                                    .logId(req.logID)
                                    .type('registration.v2')
                                    .write('Subscribe from=galatasaray to 61');

                                registrationController.accountSubscribe({
                                    uid: trackContents.uid,
                                    service_slug: 'galatasaray'
                                });
                            }

                            createSessionWithoutAJAX(req, res, next);
                        });
                    }

                    createSessionWithoutAJAX(req, res, next);
                })
                .catch(function(error) {
                    PLog.warn()
                        .logId(req.logID)
                        .type('registration.v2')
                        .write('accountRegisterAlternative', JSON.stringify(error));

                    res.locals.formErrors = error;
                    next();
                });
        })
        .catch(function(error) {
            PLog.warn()
                .logId(req.logID)
                .type('registration.v2')
                .write('accountRegisterAlternative', JSON.stringify(error));

            res.locals.formErrors = error;
            next();
        });
};
