const PLog = require('plog');
const config = require('../../configs/current');
const getRumScripts = require('../../lib/rum-counter/get-rum-script').getRumScripts;

module.exports = function rumCounterSetup(req, res, next) {
    const {version} = config;
    const {ua, regionId, experiments} = res.locals;
    const url = req._controller.getUrl();
    const page = url.pathname.replace(/\//g, '.');
    const pageId = ua && ua.isMobile ? `${page}.touch` : page;
    const rumConfig = {
        page: String(url.pathname)
            .split('/')
            .slice(0, 2)
            .join('/'),
        rumId: `${req._controller.getTld()}.passport${pageId}`,
        regionId: regionId || '',
        requestId: req.header('x-request-id') || '',
        slots: (experiments && experiments.boxes) || [],
        platform: ua && ua.isMobile ? 'touch' : 'desktop',
        experiments: (experiments && experiments.flags.join(';')) || '',
        version,
        yandexuid: req.cookies.yandexuid || '',
        referrer: req.header('referrer') || ''
    };

    getRumScripts(rumConfig)
        .then((rumScript) => {
            res.locals.rumScripts = rumScript;

            next();
        })
        .catch((err) => {
            PLog.warn()
                .logId(req.logID)
                .type('common.getRumScripts')
                .write(err);

            next();
        });
};
