const isIntranet = process.env.INTRANET === 'intranet';

function setCORSHeaders(req, res, next) {
    const origin = req.headers.origin || '';
    const originHostname = origin && origin.match(/^https:\/\/[^/]*/);

    let corsAllowedRe = /^https:\/\/(?:yandex|.+\.yandex)\.(?:ru|az|com\.am|com\.ge|co\.il|kg|lv|lt|md|tj|tm|uz|fr|ee|ua|by|kz|com|com\.tr)$/; // eslint-disable-line

    if (isIntranet) {
        corsAllowedRe = /^https:\/\/.+\.yandex-team\.ru$/;
    }

    if (originHostname && corsAllowedRe.test(originHostname)) {
        res.setHeader('Access-Control-Allow-Origin', origin);
        res.setHeader('Access-Control-Allow-Methods', 'GET, POST');
        res.setHeader('Access-Control-Allow-Credentials', 'true');
    }

    return next();
}

module.exports = setCORSHeaders;
