const geo = require('yandex-geobase')();

function setEulaFlagForGDPR(req, res, next) {
    try {
        const isRUDomain = req._controller.getTld() === 'ru';
        const isRegionRussia =
            res.locals.regionId !== undefined &&
            geo.findCountryId(res.locals.regionId, req._controller.getTld()) === 225;

        if (!isRegionRussia || !isRUDomain) {
            res.locals.store.form.isEulaShowedInPopup = true;
            res.locals.store.form.isEulaCheckedByDefault = false;
        }
    } catch (e) {
        res.locals.store.form.isEulaShowedInPopup = true;
        res.locals.store.form.isEulaCheckedByDefault = false;
    }
    return next();
}

module.exports = setEulaFlagForGDPR;
