const putils = require('putils');
const {getPreparedSocialProviders} = require('./getPreparedSocialProviders');

module.exports.getSocialProviders = function getSocialProviders(req, res, next) {
    if (res.locals.socialProviders) {
        next();

        return;
    }

    const preparedSocialProviders = getPreparedSocialProviders();

    const tld = req._controller.getTld();
    const copySocialProviders = {
        providers: [],
        primary: [],
        secondary: [],
        ...putils.cloneDeep(preparedSocialProviders[tld] || {})
    };

    const providers = [];
    const primary = [];
    const secondary = [];

    const experiments =
        (res.locals.experiments &&
            Array.isArray(res.locals.experiments.flags) &&
            res.locals.experiments.flags.reduce((acc, flag) => {
                acc[flag] = true;
                return acc;
            }, {})) ||
        {};

    const disabledCode = {
        fb: !experiments['social-provider-fb-exp'],
        esia: !experiments['social-auth-esia-exp']
    };

    const maxLength = Math.max(
        copySocialProviders.providers.length,
        copySocialProviders.primary.length,
        copySocialProviders.secondary.length
    );

    for (let i = 0; i < maxLength; i++) {
        const copyProvider = copySocialProviders.providers[i];
        const copyPrimary = copySocialProviders.primary[i];
        const copySecondary = copySocialProviders.secondary[i];

        copyProvider && !disabledCode[copyProvider.data && copyProvider.data.code] && providers.push(copyProvider);
        copyPrimary && !disabledCode[copyPrimary.data && copyPrimary.data.code] && primary.push(copyPrimary);
        copySecondary && !disabledCode[copySecondary.data && copySecondary.data.code] && secondary.push(copySecondary);
    }

    res.locals.socialProviders = {
        providers,
        primary,
        secondary
    };

    next();
};
