module.exports.prepareProviders = function prepareProviders(providers, env) {
    const result = {};

    providers.domains.forEach(function(domain) {
        const target = (result[domain.tld] = {});

        domain.providers.forEach(function(provider) {
            if (!['testing', 'development'].includes(env)) {
                if (!provider.enabled) {
                    return;
                }
            }

            provider.data = providers.providers.find(({id}) => id == provider.id);
            if (target.providers) {
                target.providers.push(provider);
            } else {
                target.providers = [provider];
            }

            if (provider.primary) {
                if (target.primary) {
                    target.primary.push(provider);
                } else {
                    target.primary = [provider];
                }
            } else if (target.secondary) {
                target.secondary.push(provider);
            } else {
                target.secondary = [provider];
            }
        });
    });

    return result;
};
