const querystring = require('querystring');

module.exports.urlFormat = function urlFormat(legacyUrlObj) {
    const dummy = new URL('https://abc.def/');
    const queryObj =
        typeof legacyUrlObj.query === 'string'
            ? querystring.parse(legacyUrlObj.query)
            : Object.assign({}, legacyUrlObj.query);

    if (typeof legacyUrlObj === 'string') {
        let result = '';

        try {
            result = new URL(legacyUrlObj).toString();

            // eslint-disable-next-line
        } catch (e) {}

        return result;
    }

    if (typeof legacyUrlObj.hostname === 'undefined' && typeof legacyUrlObj.host === 'undefined') {
        throw new Error('One of hostname or host is required');
    }

    delete legacyUrlObj.path;
    delete legacyUrlObj.href;

    Object.keys(legacyUrlObj).forEach((key) => {
        if (legacyUrlObj[key]) {
            dummy[key] = legacyUrlObj[key];
        }
    });

    dummy.search = new URLSearchParams(queryObj);

    return dummy.toString();
};

module.exports.urlParse = function urlParse(urlString) {
    const query = {};

    let parsed;

    try {
        parsed = new URL(urlString);
    } catch {
        return {};
    }

    parsed.searchParams.forEach((value, key) => (query[key] = value));

    return {
        protocol: parsed.protocol,
        host: parsed.host,
        hostname: parsed.hostname,
        port: parsed.port,
        hash: parsed.hash,
        href: parsed.href,
        pathname: parsed.pathname,
        path: `${parsed.pathname}${parsed.search}`,
        search: parsed.search,
        query,
        URL: parsed
    };
};
