const setupUserTicket = (req, res, next) => {
    if (req.hasOwnProperty('userTicket') && req.hasOwnProperty('userCity')) {
        return next();
    }

    const CITY_ATTRIBUTE = '32';

    const query = {
        get_user_ticket: 'yes',
        attributes: [CITY_ATTRIBUTE].join(',')
    };

    return req._controller
        .getAuth()
        .simpleSessionID(query)
        .then((response) => {
            if (response) {
                req.userTicket = response.user_ticket;

                if (response.attributes[CITY_ATTRIBUTE]) {
                    req.userCity = response.attributes[CITY_ATTRIBUTE];
                }
            }

            next();
        })
        .catch(() => next());
};

module.exports = setupUserTicket;
