function validateCSRF(req, res, next) {
    var controller = req._controller;

    controller
        .isCsrfTokenValidV2(req.body.csrf_token)
        .then(function(isValid) {
            if (isValid) {
                return next();
            }

            return res.status(403).json({});
        })
        .catch(function() {
            return res.status(403).json({});
        });
}

module.exports = validateCSRF;
