const PLog = require('plog');

module.exports = function validateRetpath(req, res, next) {
    const retpath = (req.query && (req.query.url || req.query.retpath)) || null;

    if (!retpath) {
        return next();
    }

    req.api
        .validateRetpath({retpath})
        .then((response = {}) => {
            const validatedRetpath = response.body && response.body.retpath;

            if (retpath) {
                res.locals.validRetpath = validatedRetpath;
            }

            return next();
        })
        .catch((error) => {
            PLog.warn()
                .logId(req.logID)
                .type('common.validateRetpath')
                .write(error);
            return next();
        });
};
