const Ajv = require('ajv');
const debug = require('debug')('passport:ajv');
const ajv = new Ajv({allErrors: true});

module.exports = ({bodySchema, querySchema}) => {
    const validateBody = Boolean(bodySchema) && ajv.compile(bodySchema);
    const validateQuery = Boolean(querySchema) && ajv.compile(querySchema);

    return (req, res, next) => {
        const isBodyValid = !validateBody || validateBody(req.body);
        const isQueryValid = !validateQuery || validateQuery(req.query);

        if (isBodyValid && isQueryValid) {
            return next();
        }

        debug({
            body: validateBody.errors,
            query: validateQuery.errors
        });

        return res.status(400).json({
            status: 'error',
            code: 'invalid'
        });
    };
};
