const getYaExperimentsFlags = require('./getYaExperimentsFlags');
const getUatraitsData = require('./getUatraitsData');

function writeStatbox(presets) {
    return [
        getYaExperimentsFlags,
        getUatraitsData,
        function(req, res, next) {
            const controller = req._controller;
            const requestParams = Object.assign({}, req.query, req.body);
            const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
            const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;
            const isMobile = String(res.locals.ua && res.locals.ua.isMobile);
            const prepared = res.locals.preparedStat || {};

            const defaults = {
                experiment_flags: experimentFlags,
                experiment_boxes: experimentBoxes,
                from: requestParams.from || null,
                host: req.hostname,
                ip: req.headers['x-real-ip'],
                is_mobile: isMobile,
                login: requestParams.login || null,
                origin: requestParams.origin || null,
                referer: req.headers.referer || null,
                retpath: requestParams.retpath || null,
                url: req.originalUrl,
                user_agent: req.headers['user-agent'],
                yandexuid: res._yandexuid,
                process_uuid: res.locals.process_uuid || requestParams.process_uuid || null,
                track_id: res.locals.track_id || requestParams.track_id || null,
                uid: res.locals.uid || requestParams.stat_uid || null,
                mode: requestParams.stat_mod,
                pathname: req.path
            };

            const dataToSend = Object.assign(defaults, presets, prepared);

            controller.writeStatbox(dataToSend);

            return next();
        }
    ];
}

module.exports = writeStatbox;
