const COOKIE_NAME = 'yaph';

module.exports = function yaphoneLite(req, res, next) {
    const lite = (req.query || {}).lite;
    const origin = (req.query || {}).origin;
    const controller = req._controller;

    if (lite === '0') {
        res.clearCookie(COOKIE_NAME);
        return next();
    }

    if (lite === '1' || controller.getCookie(COOKIE_NAME) === '1') {
        res.locals.isLite = true;
        controller.setCookie(COOKIE_NAME, '1', {
            maxAge: 24 * 60 * 60 * 1000
        });
    }

    if (origin === 'bnpl_checkout') {
        res.locals.isLite = true;
    }

    return next();
};
