(function(exports) {
    var env = 'browser';
    var _;

    try {
        env = global ? 'node' : 'browser';
    } catch (e) {
        // empty
    }

    if (env === 'node') {
        try {
            _ = require('lodash');
        } catch (e) {
            // empty
        }
    }

    function parse(data) {
        var _data = {
            simple: []
        };

        if (!data.phones) {
            return _data;
        }

        Object.keys(data.phones).forEach(function(key) {
            var _phone = data.phones[key];
            var phoneOperation = _phone.operation || {};

            if (_phone.bound || (!_phone.bound && phoneOperation.id)) {
                var phone = {
                    id: _phone.id,
                    number: _phone.number,
                    needProlong: _phone.need_admission,
                    forNotify: _phone.is_default,
                    alias: _phone.alias
                };

                if (phoneOperation.id) {
                    phone.operation = {
                        id: phoneOperation.id,
                        type: phoneOperation.type || null,
                        phone: _phone.number,
                        phoneId: _phone.id || null,
                        confirmed: Boolean(phoneOperation.password_verified && phoneOperation.code.confirmed)
                    };

                    if (phoneOperation.type === 'replace' && phoneOperation.phone_id2) {
                        phone.operation.phoneIdReplaced = phoneOperation.phone_id2;
                    }

                    phone.owner = Boolean(phoneOperation.does_user_admit_phone);

                    if (phoneOperation.in_quarantine) {
                        phone.quarantineEnd = Math.ceil(
                            (new Date(phoneOperation.finished * 1000).getTime() - Date.now()) / 1000 / 60 / 60 / 24
                        );
                        phone.quarantine = phoneOperation.in_quarantine;
                    }
                }

                if (_phone.secured || phoneOperation.is_secure_phone_operation) {
                    _data.secure = phone;
                } else {
                    _data.simple.push(phone);
                }
            }
        });

        if (_data.secure && _data.secure.operation && _data.secure.operation.type === 'replace') {
            var replacedPhone;

            if (env === 'node') {
                replacedPhone = _.find(_data.simple, function(phone) {
                    return phone.id === _data.secure.operation.phoneIdReplaced;
                });
            } else if (Array.prototype.find) {
                replacedPhone = _data.simple.find(function(phone) {
                    return phone.id === _data.secure.operation.phoneIdReplaced;
                });
            }

            if (replacedPhone.operation.type === 'bind') {
                replacedPhone.operation.type = 'mark';
            }

            if (replacedPhone) {
                if (!_data.secure.owner || _data.secure.operation.confirmed) {
                    if (env === 'node') {
                        _data.secure.operation = _.extend({}, replacedPhone.operation);
                    } else if (env === 'browser' && $ !== undefined) {
                        _data.secure.operation = $.extend({}, replacedPhone.operation);
                    }

                    _data.secure.operation.step = 'confirm-simple';
                    _data.secure.operation.type = 'replace';
                } else {
                    _data.secure.operation.step = 'confirm-secure';
                }
            }
        }

        _data.totalCount = _data.secure && _data.secure.id ? 1 : 0;
        _data.totalCount += _data.simple.length;

        return _data;
    }

    exports.parse = function(data) {
        return parse(data);
    };
})(exports);
