const express = require('express');
const config = require('../configs/current');
const apiSetup = require('./common/apiSetup');
const langSetup = require('./common/langSetup');
const {urlFormat} = require('./common/urlFormat');
const getMetrics = require('./common/getMetrics');
const apiRequest = require('./authv2/apiRequest');
const writeStatbox = require('./common/writeStatbox');
const rumCounterSetup = require('./common/rumCounterSetup');
const getUatraitsData = require('./common/getUatraitsData');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');

const router = express.Router();
const setup = [apiSetup, langSetup];

router.get('/', [
    setup,
    getUatraitsData,
    getYaExperimentsFlags,
    rumCounterSetup,
    apiRequest('authPasswordSubmit'),
    apiRequest('validateRetpath'),
    (req, res, next) => {
        const {
            ua,
            csrf,
            language,
            experiments: {encodedBoxes = ''} = {},
            userType: {metricsUserType} = {},
            result: {
                validateRetpath: {retpath = ''} = {},
                authPasswordSubmit: {track_id: magicTrack, csrf_token: magicCSRF} = {}
            } = {}
        } = res.locals;
        const {
            version,
            paths: {static: staticPath}
        } = config;

        res.locals.store = {
            settings: {
                version,
                retpath,
                staticPath,
                metricsUserType,
                lang: language,
                tld: req._controller.getTld(),
                isDark: req.query.theme === 'dark',
                isMobile: (ua.isMobile || ua.isTouch) && !ua.isTablet
            },
            common: {
                csrf,
                authUrl: urlFormat({
                    ...req._controller.getAuthUrl(),
                    query: {retpath}
                }),
                authChallengeUrl: urlFormat({
                    ...req._controller.getUrl(),
                    pathname: '/auth/challenge',
                    query: {retpath}
                })
            },
            metrics: {
                experiments: encodedBoxes
            },
            deepSync: {
                magicCSRF,
                magicTrack,
                error: null,
                isLoading: !magicCSRF || !magicTrack
            }
        };

        return next();
    },
    (req, res, next) => {
        res.removeHeader('X-Frame-Options');

        res.locals.preparedStat = {
            track_id: res.locals.store.trackId
        };

        next();
    },
    writeStatbox({
        action: 'opened',
        mode: 'deepsync'
    }),
    getMetrics({
        header: 'DeepSync'
    }),
    (req, res) => res.render(`react.deepsync.${res.locals.language}.jsx`)
]);

exports.router = router;
