var url = require('url');
var apiSetup = require('./common/apiSetup');
var config = require('../configs/current');

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;
    var pddRoute = '/for/:pdd_domain/migrate*';

    app.all(pddRoute, routes.main);
};

exports.routes.main = [apiSetup, doMigration(), redirectToAuthIfError];

exports.getConfig = function() {
    return config;
};

function doMigration(retpath) {
    return function(req, res, next) {
        var config = exports.getConfig();
        const controller = req._controller;

        var data = {
            retpath: retpath || req.body['retpath'] || (req.nquery && req.nquery['retpath'])
        };

        req.api.authSubmit('/1/bundle/auth/migrate_pdd/', data).done(
            function(results) {
                var body = results.body;
                var target;
                var pdd;
                var finishPathname;

                controller.augmentResponse(body);

                if (body.cookies && body.cookies.length) {
                    pdd = body.account && body.account.domain && body.account.domain.unicode;
                    finishPathname =
                        pdd && !config.multiauth ? `/for/${encodeURIComponent(pdd)}/finish/` : '/auth/finish/';

                    target = url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname: finishPathname,
                        query: {
                            track_id: body.track_id
                        }
                    });

                    return res.redirect(target);
                } else if (body.retpath) {
                    return res.redirect(body.retpath);
                } else {
                    return next('no_cookie_and_no_retpath');
                }
            },
            function(error) {
                return next(error);
            }
        );
    };
}

// eslint-disable-next-line no-unused-vars
function redirectToAuthIfError(err, req, res, next) {
    var query = {};
    var retpath = req.body['retpath'] || (req.nquery && req.nquery['retpath']);

    if (retpath) {
        query['retpath'] = retpath;
    }

    return res.redirect(
        url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: '/auth/',
            query
        })
    );
}

exports.doMigration = doMigration;
exports.redirectToAuthIfError = redirectToAuthIfError;
