const {okHandler, errorHandler} = require('./utils');
const {checkFamilyExist, fetchInviteInfo} = require('../utils');

exports.getInviteInfo = (req, res) =>
    fetchInviteInfo(req, res, req.body.inviteId)
        .then(({admin}) => okHandler(req, res, {admin})())
        .catch(errorHandler(req, res));

exports.confirmInvite = (req, res) =>
    req.api
        .confirmFamilyInvite(req.body.inviteId)
        .then(okHandler(req, res))
        .catch(errorHandler(req, res));

exports.createInvite = (req, res) => {
    const {contact = ''} = req.body;
    const inviteRequest = {
        sms_phone_country: 'ru'
    };

    let inviteMethod = '';

    if (contact) {
        inviteMethod = contact.toString().includes('@') ? 'email' : 'sms_phone';
        inviteRequest[inviteMethod] = contact;
        if (inviteMethod === 'sms_phone') {
            inviteMethod = 'sms';
        }
    }

    checkFamilyExist(req, res)
        .then(() => req.api.createFamilyInvite(inviteRequest))
        .then(({body: {invite_id: inviteId}}) => {
            okHandler(req, res, {inviteId, inviteContact: contact, inviteMethod})();
        })
        .catch((errors) => {
            if (errors && errors[0] === 'email.invalid') {
                return errorHandler(req, res)(['sms_phone.invalid']);
            }
            return errorHandler(req, res)(errors);
        });
};

exports.cancelInvite = (req, res) =>
    req.api
        .cancelFamilyInvite(req.body.inviteId)
        .then(okHandler(req, res))
        .catch((errors) => {
            if (errors && errors[0] === 'family.invalid_invite') {
                return errorHandler(req, res)(['family.cant_remove_invite']);
            }
            return errorHandler(req, res)(errors);
        });
