const {okHandler, errorHandler} = require('./utils');
const {checkFamilyExist} = require('../utils');

const getKiddishInfoFromBody = ({
    name,
    avatar,
    birthday,
    rating,
    musicRating,
    videoRating,
    firstname,
    gender,
    lastname,
    uid
}) => ({
    display_name: name,
    avatar_id: avatar,
    kiddish_uid: uid,
    content_rating_class: rating,
    music_content_rating_class: musicRating,
    video_content_rating_class: videoRating,
    birthday,
    firstname, // Не используется, но есть в доке
    lastname, // Не используется, но есть в доке
    gender
});

exports.createKiddish = (req, res) =>
    checkFamilyExist(req, res)
        .then(() => req.api.createKiddish(getKiddishInfoFromBody(req.body)))
        .then(okHandler(req, res))
        .catch((errors) => {
            if (errors && errors[0] === 'family.max_capacity') {
                return errorHandler(req, res)(['kiddish.max_capacity']);
            }
            return errorHandler(req, res)(errors);
        });

exports.editKiddish = (req, res) =>
    req.api
        .editKiddish(getKiddishInfoFromBody(req.body))
        .then(okHandler(req, res))
        .catch(errorHandler(req, res));

exports.removeKiddish = (req, res) =>
    req.api
        .removeKiddish(getKiddishInfoFromBody(req.body))
        .then(okHandler(req, res))
        .catch(errorHandler(req, res));
