const {okHandler, errorHandler} = require('./utils');

exports.excludeMember = (req, res) =>
    req.api
        .deleteFamilyMember(req.body.placeId)
        .then(okHandler(req, res))
        .catch((errors) => {
            if (errors && errors[0] === 'family.is_member_other') {
                return errorHandler(req, res)(['family.is_not_a_member']);
            }
            return errorHandler(req, res)(errors);
        });

exports.leaveFamily = (req, res) =>
    req.api
        .leaveFamily()
        .then(okHandler(req, res))
        .catch(errorHandler(req, res));
