const BillingApi = require('../../../lib/api/billing');
const {okHandler} = require('./utils');

const getProductPrice = (product) => (product.introPrice || product.price).amount;

const getCheapestProduct = (products) => products.sort((i, j) => getProductPrice(i) - getProductPrice(j))[0];

const getCheapestIntroProduct = (products) => {
    const introProducts = products.filter((i) => i.introPeriodDuration);

    return getCheapestProduct(introProducts.length ? introProducts : products);
};

const getProduct = (products) => {
    const familyProducts = products.filter((i) => i.available && i.family);
    const trialProducts = familyProducts.filter((i) => i.trialDuration);

    return getCheapestIntroProduct(trialProducts.length ? trialProducts : familyProducts);
};

exports.getSubscriptionOffer = async (req, res) => {
    const controller = req._controller;
    const uid = controller.getAuth().getUid();
    const {language} = req.body;

    if (!uid || !language) {
        return okHandler(req, res)();
    }

    try {
        const {result: {nativeProducts: products} = {}} = await new BillingApi(req.logID).getNativeProducts({
            uid,
            ip: req.ip,
            target: 'passport-family',
            language
        });

        const {buttonText: text, buttonAdditionalText: subText} = getProduct(products || []) || {};

        okHandler(req, res, {text, subText})();
    } catch {
        okHandler(req, res)();
    }
};
