const CONSTS = require('../const');
const {fetchFamilyInfo, createFamilyPayApi, postBindCard} = require('../utils');
const {okHandler, errorHandler} = require('./utils');

exports.payUnbind = async (req, res) => {
    const {familyId} = await fetchFamilyInfo(req, res, {withBBUsers: false});

    createFamilyPayApi(req, res)
        .updateCardBound(familyId, false)
        .then(okHandler(req, res), errorHandler(req, res));
};

exports.payBind = async (req, res) => {
    const {cardId, track_id: trackId, retpath = '', origin = ''} = req.body;

    return postBindCard(req, res, trackId, cardId, retpath, origin).then(
        (result = {}) =>
            result.state === 'error' ? errorHandler(req, res)(result.error) : okHandler(req, res, result)(),
        errorHandler(req, res)
    );
};

exports.paySaveLimits = async (req, res) => {
    const {familyId = '', members = []} = await fetchFamilyInfo(req, res, {withUid: true});
    const {limits = {}} = req.body;
    const {users = []} = JSON.parse(limits);
    const newLimits = users.map(
        ({placeId, currency, limit: {limitMode, value} = {}, allowedServices = [], isEnabled, allowAllServices}) => {
            const newLimitMode = limitMode === 'NOLIMIT' ? 'DAY' : limitMode;
            const newValue = limitMode === 'NOLIMIT' ? CONSTS.PAY_NO_LIMIT_VALUE : Number(value);
            const limitsForm = {
                uid: members.find((member) => member.placeId === placeId).uid,
                limitCurrency: currency,
                limit: {limitMode: newLimitMode, value: newValue * CONSTS.PAY_PENNY_COUNT},
                enabled: isEnabled
            };

            if (allowAllServices) {
                limitsForm.allowAllServices = allowAllServices;
            } else {
                limitsForm.allowedServices = allowedServices;
            }

            return limitsForm;
        }
    );

    createFamilyPayApi(req, res)
        .updateUsersSingleLimit(familyId, newLimits)
        .then(okHandler(req, res), errorHandler(req, res));
};

exports.payResetUserExpenses = async (req, res) => {
    const {placeId = ''} = req.body;
    const {members = []} = await fetchFamilyInfo(req, res, {withUid: true});

    createFamilyPayApi(req, res)
        .resetUserExpenses(members.find((member) => member.placeId === placeId).uid)
        .then(okHandler(req, res), errorHandler(req, res));
};
