const CONSTS = require('../const');

module.exports.errorHandler = (req, res) => (err) =>
    res.json({
        status: CONSTS.STATUS.ERROR,
        code: Array.isArray(err) ? err[0] : typeof err === 'string' ? err : CONSTS.COMMON_ERROR
    });

module.exports.okHandler = (req, res, obj = {}) => () => res.json(Object.assign({status: CONSTS.STATUS.OK}, obj));
