const apiSetup = require('../common/apiSetup');
const getYaExperimentsFlags = require('../common/getYaExperimentsFlags');
const validateCSRF = require('../common/validateCSRF.js');
const setupUserTicket = require('../common/userTicketsSetup');
const api = require('./api');

const setup = [validateCSRF, apiSetup, setupUserTicket];

module.exports.route = (app) => {
    app.post('/profile/family/common/state', [...setup, api.common.getFamily]);
    app.post('/profile/family/common/delete', [...setup, api.common.deleteFamily]);
    app.post('/profile/family/member/leave', [...setup, api.member.leaveFamily]);
    app.post('/profile/family/member/exclude', [...setup, api.member.excludeMember]);
    app.post('/profile/family/invite/state', [...setup, api.invite.getInviteInfo]);
    app.post('/profile/family/invite/accept', [...setup, api.invite.confirmInvite]);
    app.post('/profile/family/invite/cancel', [...setup, api.invite.cancelInvite]);
    app.post('/profile/family/invite/create', [...setup, api.invite.createInvite]);
    app.post('/profile/family/offer/state', [...setup, api.offer.getSubscriptionOffer]);
    app.post('/profile/family/kiddish/create', [...setup, api.kiddish.createKiddish]);
    app.post('/profile/family/kiddish/edit', [...setup, api.kiddish.editKiddish]);
    app.post('/profile/family/kiddish/remove', [...setup, api.kiddish.removeKiddish]);
    app.post('/profile/family/pay/unbind', [...setup, api.pay.payUnbind]);
    app.post('/profile/family/pay/bind', [...setup, getYaExperimentsFlags, api.pay.payBind]);
    app.post('/profile/family/pay/limits', [...setup, api.pay.paySaveLimits]);
    app.post('/profile/family/pay/balance', [...setup, api.pay.payResetUserExpenses]);
    app.post('/profile/family/childish/rating', [...setup, api.childish.postRating]);
};
